/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.immutable.util.ParamUtil;

public class CustomInlineMethodResolver
extends InlineMethodResolver {
    @Nonnull
    private final ClassPath classPath;
    @Nonnull
    private final Method[] inlineMethods;
    private static final Pattern longMethodPattern = Pattern.compile("(L[^;]+;)->([^(]+)\\(([^)]*)\\)(.+)");

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull String inlineTable) {
        this.classPath = classPath;
        StringReader reader = new StringReader(inlineTable);
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while parsing inline table", ex);
        }
        this.inlineMethods = new Method[lines.size()];
        for (int i = 0; i < this.inlineMethods.length; ++i) {
            this.inlineMethods[i] = this.parseAndResolveInlineMethod((String)lines.get(i));
        }
    }

    public CustomInlineMethodResolver(@Nonnull ClassPath classPath, @Nonnull File inlineTable) throws IOException {
        this(classPath, Files.toString(inlineTable, Charset.forName("UTF-8")));
    }

    @Override
    @Nonnull
    public Method resolveExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
        InlineIndexInstruction instruction = (InlineIndexInstruction)analyzedInstruction.instruction;
        int methodIndex = instruction.getInlineIndex();
        if (methodIndex < 0 || methodIndex >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid method index: " + methodIndex);
        }
        return this.inlineMethods[methodIndex];
    }

    @Nonnull
    private Method parseAndResolveInlineMethod(@Nonnull String inlineMethod) {
        Matcher m3 = longMethodPattern.matcher(inlineMethod);
        if (!m3.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + inlineMethod);
        }
        String className = m3.group(1);
        String methodName = m3.group(2);
        Iterable<ImmutableMethodParameter> methodParams = ParamUtil.parseParamString(m3.group(3));
        String methodRet = m3.group(4);
        ImmutableMethodReference methodRef = new ImmutableMethodReference(className, methodName, methodParams, methodRet);
        int accessFlags = 0;
        boolean resolved = false;
        TypeProto typeProto = this.classPath.getClass(className);
        if (typeProto instanceof ClassProto) {
            ClassDef classDef = ((ClassProto)typeProto).getClassDef();
            for (Method method : classDef.getMethods()) {
                if (!method.equals(methodRef)) continue;
                resolved = true;
                accessFlags = method.getAccessFlags();
                break;
            }
        }
        if (!resolved) {
            throw new RuntimeException("Cannot resolve inline method: " + inlineMethod);
        }
        return new ImmutableMethod(className, methodName, methodParams, methodRet, accessFlags, null, null);
    }
}

