/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.HtmlUtil;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

public final class TokenUtils {
    private TokenUtils() {
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e, RSyntaxTextArea textArea, float x0) {
        return TokenUtils.getSubTokenList(tokenList, pos, e, textArea, x0, null);
    }

    public static TokenSubList getSubTokenList(Token tokenList, int pos, TabExpander e, RSyntaxTextArea textArea, float x0, TokenImpl tempToken) {
        Token t;
        if (tempToken == null) {
            tempToken = new TokenImpl();
        }
        for (t = tokenList; t != null && t.isPaintable() && !t.containsPosition(pos); t = t.getNextToken()) {
            x0 += t.getWidth(textArea, e, x0);
        }
        if (t != null && t.isPaintable()) {
            if (t.getOffset() != pos) {
                int difference = pos - t.getOffset();
                x0 += t.getWidthUpTo(t.length() - difference + 1, textArea, e, x0);
                tempToken.copyFrom(t);
                tempToken.makeStartAt(pos);
                return new TokenSubList(tempToken, x0);
            }
            return new TokenSubList(t, x0);
        }
        return new TokenSubList(tokenList, x0);
    }

    public static String tokenToHtml(RSyntaxTextArea textArea, Token token) {
        StringBuilder style2 = new StringBuilder();
        Font font = textArea.getFontForTokenType(token.getType());
        if (font.isBold()) {
            style2.append("font-weight: bold;\n");
        }
        if (font.isItalic()) {
            style2.append("font-style: italic;\n");
        }
        Color c = textArea.getForegroundForToken(token);
        style2.append("color: ").append(HtmlUtil.getHexString(c)).append(";\n");
        return "<span style=\"" + style2 + "\">" + HtmlUtil.escapeForHtml(token.getLexeme(), "\n", true) + "</span>";
    }

    public static class TokenSubList {
        public Token tokenList;
        public float x;

        public TokenSubList(Token tokenList, float x) {
            this.tokenList = tokenList;
            this.x = x;
        }
    }
}

