/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.search.SearchIndex;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeIndex<T>
implements SearchIndex<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CodeIndex.class);
    private final List<StringRef> keys = new ArrayList<StringRef>();
    private final List<T> values = new ArrayList<T>();

    @Override
    public void put(String str, T value) {
        throw new UnsupportedOperationException("CodeIndex.put for string not supported");
    }

    @Override
    public synchronized void put(StringRef str, T value) {
        if (str == null || str.length() == 0) {
            return;
        }
        this.keys.add(str);
        this.values.add(value);
    }

    @Override
    public boolean isStringRefSupported() {
        return true;
    }

    private boolean isMatched(StringRef key, String str, boolean caseInsensitive) {
        return key.indexOf(str, caseInsensitive) != -1;
    }

    @Override
    public Flowable<T> search(String searchStr, boolean caseInsensitive) {
        return Flowable.create(emitter -> {
            int size = this.size();
            LOG.debug("Code search started: {} ...", (Object)searchStr);
            for (int i = 0; i < size; ++i) {
                if (this.isMatched(this.keys.get(i), searchStr, caseInsensitive)) {
                    emitter.onNext(this.values.get(i));
                }
                if (!emitter.isCancelled()) continue;
                LOG.debug("Code search canceled: {}", (Object)searchStr);
                return;
            }
            LOG.debug("Code search complete: {}, memory usage: {}", (Object)searchStr, (Object)UiUtils.memoryInfo());
            emitter.onComplete();
        }, BackpressureStrategy.LATEST);
    }

    @Override
    public int size() {
        return this.keys.size();
    }
}

