/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.UiUtils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FontUtils.class);
    public static final Font FONT_HACK = FontUtils.openFontTTF("Hack-Regular");

    public static void registerBundledFonts() {
        GraphicsEnvironment grEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (FONT_HACK != null) {
            grEnv.registerFont(FONT_HACK);
        }
    }

    public static Font loadByStr(String fontDesc) {
        String[] parts = fontDesc.split("-");
        if (parts.length != 3) {
            throw new JadxRuntimeException("Unsupported font description format: " + fontDesc);
        }
        String name = parts[0];
        int style2 = FontUtils.parseFontStyle(parts[1]);
        int size = Integer.parseInt(parts[2]);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Font font = sc.getFont(name, style2, size);
        if (font == null) {
            throw new JadxRuntimeException("Font not found: " + fontDesc);
        }
        return font;
    }

    public static String convertToStr(Font font) {
        return font.getFontName() + '-' + FontUtils.convertFontStyleToString(font.getStyle()) + '-' + font.getSize();
    }

    public static String convertFontStyleToString(int style2) {
        if (style2 == 0) {
            return "plain";
        }
        StringBuilder sb = new StringBuilder();
        if ((style2 & 1) != 0) {
            sb.append("bold");
        }
        if ((style2 & 2) != 0) {
            sb.append(" italic");
        }
        return sb.toString().trim();
    }

    private static int parseFontStyle(String str) {
        int style2 = 0;
        if (str.contains("bold")) {
            style2 |= 1;
        }
        if (str.contains("italic")) {
            style2 |= 2;
        }
        return style2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Font openFontTTF(String name) {
        String fontPath = "/fonts/" + name + ".ttf";
        try (InputStream is = UiUtils.class.getResourceAsStream(fontPath);){
            Font font2 = Font.createFont(0, is);
            Font font = font2.deriveFont(12.0f);
            return font;
        }
        catch (Exception e) {
            LOG.error("Failed load font by path: {}", (Object)fontPath, (Object)e);
            return null;
        }
    }

    private FontUtils() {
    }
}

