/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.gui.ui.codearea.CodeArea;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.modes.JavaTokenMaker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxTokenMaker
extends JavaTokenMaker {
    private static final Logger LOG = LoggerFactory.getLogger(JadxTokenMaker.class);
    private final CodeArea codeArea;

    public JadxTokenMaker(CodeArea codeArea) {
        this.codeArea = codeArea;
    }

    @Override
    public Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        Token tokens = super.getTokenList(text, initialTokenType, startOffset);
        if (startOffset > 0 && tokens.getType() != 0) {
            try {
                this.processTokens(tokens);
            }
            catch (Exception e) {
                LOG.error("Process tokens failed for text: {}", (Object)text, (Object)e);
            }
        }
        return tokens;
    }

    private void processTokens(Token tokens) {
        Token prev = null;
        for (Token current = tokens; current != null; current = current.getNextToken()) {
            if (prev != null) {
                int tokenType = current.getType();
                if (tokenType == 20) {
                    current = this.mergeLongClassNames(prev, current, false);
                } else if (tokenType == 19) {
                    current = this.mergeLongClassNames(prev, current, true);
                }
            }
            prev = current;
        }
    }

    @NotNull
    private Token mergeLongClassNames(Token prev, Token current, boolean annotation) {
        JavaNode javaNode;
        int offset = current.getOffset();
        if (annotation) {
            ++offset;
        }
        if ((javaNode = this.codeArea.getJavaNodeAtOffset(offset)) instanceof JavaClass) {
            Token replace;
            String name = javaNode.getName();
            String lexeme = current.getLexeme();
            if (annotation && lexeme.length() > 1) {
                lexeme = lexeme.substring(1);
            }
            if (!lexeme.equals(name) && javaNode.getFullName().startsWith(lexeme) && (replace = this.concatTokensUntil(current, name)) != null && prev instanceof TokenImpl) {
                TokenImpl impl = (TokenImpl)prev;
                impl.setNextToken(replace);
                current = replace;
            }
        }
        return current;
    }

    @Nullable
    private Token concatTokensUntil(Token start, String endText) {
        StringBuilder sb = new StringBuilder();
        for (Token current = start; current != null && current.getType() != 0; current = current.getNextToken()) {
            String text = current.getLexeme();
            if (text == null) continue;
            sb.append(text);
            if (!text.equals(endText)) continue;
            char[] line = sb.toString().toCharArray();
            TokenImpl token = new TokenImpl(line, 0, line.length - 1, start.getOffset(), start.getType(), start.getLanguageIndex());
            token.setNextToken(current.getNextToken());
            return token;
        }
        return null;
    }
}

