/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.LineNumbers;
import jadx.gui.ui.codearea.SearchBar;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class CodePanel
extends JPanel {
    private static final long serialVersionUID = 1117721869391885865L;
    private final SearchBar searchBar;
    private final AbstractCodeArea codeArea;
    private final JScrollPane codeScrollPane;

    public CodePanel(AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
        this.searchBar = new SearchBar(codeArea);
        this.codeScrollPane = new JScrollPane(codeArea);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.searchBar, "North");
        this.add((Component)this.codeScrollPane, "Center");
        KeyStroke key = KeyStroke.getKeyStroke(70, UiUtils.ctrlButton());
        UiUtils.addKeyBinding(codeArea, key, "SearchAction", new AbstractAction(){
            private static final long serialVersionUID = 71338030532869694L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CodePanel.this.searchBar.toggle();
            }
        });
    }

    public void loadSettings() {
        this.codeArea.loadSettings();
        this.initLineNumbers();
    }

    public void load() {
        this.codeArea.load();
        this.initLineNumbers();
    }

    private void initLineNumbers() {
        LineNumbers numbers = new LineNumbers(this.codeArea);
        numbers.setUseSourceLines(this.isUseSourceLines());
        this.codeScrollPane.setRowHeaderView(numbers);
    }

    private boolean isUseSourceLines() {
        if (this.codeArea instanceof SmaliArea) {
            return false;
        }
        ICodeInfo codeInfo = this.codeArea.getNode().getCodeInfo();
        if (codeInfo == null) {
            return false;
        }
        Map<Integer, Integer> lineMapping = codeInfo.getLineMapping();
        if (lineMapping.isEmpty()) {
            return false;
        }
        HashSet<Integer> uniqueSourceLines = new HashSet<Integer>(lineMapping.values());
        return uniqueSourceLines.size() > 3;
    }

    public SearchBar getSearchBar() {
        return this.searchBar;
    }

    public AbstractCodeArea getCodeArea() {
        return this.codeArea;
    }

    public JScrollPane getCodeScrollPane() {
        return this.codeScrollPane;
    }
}

