/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jadx.gui.settings.JadxSettings;
import jadx.gui.utils.PathTypeAdapter;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxProject {
    private static final Logger LOG = LoggerFactory.getLogger(JadxProject.class);
    private static final int CURRENT_SETTINGS_VERSION = 0;
    public static final String PROJECT_EXTENSION = "jadx";
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, PathTypeAdapter.singleton()).create();
    private transient JadxSettings settings;
    private transient String name = "New Project";
    private transient Path projectPath;
    private List<Path> filesPath;
    private List<String[]> treeExpansions = new ArrayList<String[]>();
    private transient boolean saved;
    private transient boolean initial = true;
    private int projectVersion = 0;

    public JadxProject() {
    }

    public JadxProject(JadxSettings settings) {
        this.settings = settings;
    }

    public void setSettings(JadxSettings settings) {
        this.settings = settings;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    private void setProjectPath(Path projectPath) {
        this.projectPath = projectPath;
        if (this.projectVersion != 0) {
            this.upgradeSettings(this.projectVersion);
        }
        this.name = projectPath.getFileName().toString();
        this.name = this.name.substring(0, this.name.lastIndexOf(46));
        this.changed();
    }

    public Path getFilePath() {
        return this.filesPath == null ? null : this.filesPath.get(0);
    }

    public void setFilePath(Path filePath) {
        if (!filePath.equals(this.getFilePath())) {
            this.filesPath = Arrays.asList(filePath);
            this.changed();
        }
    }

    public List<String[]> getTreeExpansions() {
        return this.treeExpansions;
    }

    public void addTreeExpansion(String[] expansion) {
        this.treeExpansions.add(expansion);
        this.changed();
    }

    public void removeTreeExpansion(String[] expansion) {
        Iterator<String[]> it = this.treeExpansions.iterator();
        while (it.hasNext()) {
            if (!this.isParentOfExpansion(expansion, it.next())) continue;
            it.remove();
        }
        this.changed();
    }

    private boolean isParentOfExpansion(String[] parent, String[] child) {
        if (Arrays.equals(parent, child)) {
            return true;
        }
        for (int i = child.length - parent.length; i > 0; --i) {
            Object[] arr = Arrays.copyOfRange(child, i, child.length);
            if (!Arrays.equals(parent, arr)) continue;
            return true;
        }
        return false;
    }

    private void changed() {
        if (this.settings.isAutoSaveProject()) {
            this.save();
        } else {
            this.saved = false;
        }
        this.initial = false;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void saveAs(Path path) {
        this.setProjectPath(path);
        this.save();
    }

    public void save() {
        if (this.getProjectPath() != null) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.getProjectPath(), new OpenOption[0]);){
                writer.write(GSON.toJson(this));
                this.saved = true;
            }
            catch (Exception e) {
                LOG.error("Error saving project", e);
            }
        }
    }

    public static JadxProject from(Path path, JadxSettings settings) {
        try {
            List<String> lines = Files.readAllLines(path);
            if (!lines.isEmpty()) {
                JadxProject project = GSON.fromJson(lines.get(0), JadxProject.class);
                project.settings = settings;
                project.setProjectPath(path);
                project.saved = true;
                return project;
            }
        }
        catch (Exception e) {
            LOG.error("Error loading project", e);
        }
        return null;
    }

    private void upgradeSettings(int fromVersion) {
        LOG.debug("upgrade settings from version: {} to {}", (Object)fromVersion, (Object)0);
        if (fromVersion == 0) {
            ++fromVersion;
        }
        this.projectVersion = 0;
        this.save();
    }
}

