/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSecurity.class);
    private static final int MAX_SIZE_DIFF = 100;

    private ZipSecurity() {
    }

    private static boolean isInSubDirectoryInternal(File baseDir, File canonFile) {
        if (canonFile == null) {
            return false;
        }
        if (canonFile.equals(baseDir)) {
            return true;
        }
        return ZipSecurity.isInSubDirectoryInternal(baseDir, canonFile.getParentFile());
    }

    public static boolean isInSubDirectory(File baseDir, File file) {
        try {
            file = file.getCanonicalFile();
            baseDir = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return ZipSecurity.isInSubDirectoryInternal(baseDir, file);
    }

    public static boolean isValidZipEntryName(String entryName) {
        try {
            File currentPath = new File(".").getCanonicalFile();
            File canonical = new File(currentPath, entryName).getCanonicalFile();
            if (ZipSecurity.isInSubDirectoryInternal(currentPath, canonical)) {
                return true;
            }
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
        catch (Exception e) {
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
    }

    public static boolean isZipBomb(ZipEntry entry) {
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
            return true;
        }
        if (compressedSize * 100L < uncompressedSize) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", compressedSize, uncompressedSize, entry.getName());
            return true;
        }
        return false;
    }

    public static boolean isValidZipEntry(ZipEntry entry) {
        return ZipSecurity.isValidZipEntryName(entry.getName()) && !ZipSecurity.isZipBomb(entry);
    }
}

