/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.parser;

import com.android.dex.Dex;
import com.android.dex.Leb128;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.parser.AnnotationsParser;
import jadx.core.utils.exceptions.DecodeException;
import java.util.ArrayList;

public class EncValueParser {
    private static final int ENCODED_BYTE = 0;
    private static final int ENCODED_SHORT = 2;
    private static final int ENCODED_CHAR = 3;
    private static final int ENCODED_INT = 4;
    private static final int ENCODED_LONG = 6;
    private static final int ENCODED_FLOAT = 16;
    private static final int ENCODED_DOUBLE = 17;
    private static final int ENCODED_STRING = 23;
    private static final int ENCODED_TYPE = 24;
    private static final int ENCODED_FIELD = 25;
    private static final int ENCODED_ENUM = 27;
    private static final int ENCODED_METHOD = 26;
    private static final int ENCODED_ARRAY = 28;
    private static final int ENCODED_ANNOTATION = 29;
    private static final int ENCODED_NULL = 30;
    private static final int ENCODED_BOOLEAN = 31;
    protected final Dex.Section in;
    private final DexNode dex;

    public EncValueParser(DexNode dex, Dex.Section in) {
        this.in = in;
        this.dex = dex;
    }

    public Object parseValue() throws DecodeException {
        int argAndType = this.readByte();
        int type = argAndType & 0x1F;
        int arg = (argAndType & 0xE0) >> 5;
        int size = arg + 1;
        switch (type) {
            case 30: {
                return null;
            }
            case 31: {
                return arg == 1;
            }
            case 0: {
                return this.in.readByte();
            }
            case 2: {
                return (short)this.parseNumber(size, true);
            }
            case 3: {
                return Character.valueOf((char)this.parseUnsignedInt(size));
            }
            case 4: {
                return (int)this.parseNumber(size, true);
            }
            case 6: {
                return this.parseNumber(size, true);
            }
            case 16: {
                return Float.valueOf(Float.intBitsToFloat((int)this.parseNumber(size, false, 4)));
            }
            case 17: {
                return Double.longBitsToDouble(this.parseNumber(size, false, 8));
            }
            case 23: {
                return this.dex.getString(this.parseUnsignedInt(size));
            }
            case 24: {
                return this.dex.getType(this.parseUnsignedInt(size));
            }
            case 26: {
                return MethodInfo.fromDex(this.dex, this.parseUnsignedInt(size));
            }
            case 25: 
            case 27: {
                return FieldInfo.fromDex(this.dex, this.parseUnsignedInt(size));
            }
            case 28: {
                int count = Leb128.readUnsignedLeb128(this.in);
                ArrayList<Object> values = new ArrayList<Object>(count);
                for (int i = 0; i < count; ++i) {
                    values.add(this.parseValue());
                }
                return values;
            }
            case 29: {
                return AnnotationsParser.readAnnotation(this.dex, this.in, false);
            }
        }
        throw new DecodeException("Unknown encoded value type: 0x" + Integer.toHexString(type));
    }

    private int parseUnsignedInt(int byteCount) {
        return (int)this.parseNumber(byteCount, false, 0);
    }

    private long parseNumber(int byteCount, boolean isSignExtended) {
        return this.parseNumber(byteCount, isSignExtended, 0);
    }

    private long parseNumber(int byteCount, boolean isSignExtended, int fillOnRight) {
        long result;
        block4: {
            int i;
            long last;
            block3: {
                result = 0L;
                last = 0L;
                for (i = 0; i < byteCount; ++i) {
                    last = this.readByte();
                    result |= last << i * 8;
                }
                if (fillOnRight == 0) break block3;
                for (i = byteCount; i < fillOnRight; ++i) {
                    result <<= 8;
                }
                break block4;
            }
            if (!isSignExtended || (last & 0x80L) == 0L) break block4;
            for (i = byteCount; i < 8; ++i) {
                result |= 255L << i * 8;
            }
        }
        return result;
    }

    private int readByte() {
        return this.in.readByte() & 0xFF;
    }
}

