/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.parser;

import com.android.dex.Dex;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.attributes.annotations.AnnotationsList;
import jadx.core.dex.attributes.annotations.MethodParameters;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.parser.EncValueParser;
import jadx.core.utils.exceptions.DecodeException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class AnnotationsParser {
    private static final Annotation.Visibility[] VISIBILITIES = new Annotation.Visibility[]{Annotation.Visibility.BUILD, Annotation.Visibility.RUNTIME, Annotation.Visibility.SYSTEM};
    private final DexNode dex;
    private final ClassNode cls;

    public AnnotationsParser(ClassNode cls) {
        this.cls = cls;
        this.dex = cls.dex();
    }

    public void parse(int offset) throws DecodeException {
        int i;
        Dex.Section section = this.dex.openSection(offset);
        int classAnnotationsOffset = section.readInt();
        int fieldsCount = section.readInt();
        int annotatedMethodsCount = section.readInt();
        int annotatedParametersCount = section.readInt();
        if (classAnnotationsOffset != 0) {
            this.cls.addAttr(this.readAnnotationSet(classAnnotationsOffset));
        }
        for (i = 0; i < fieldsCount; ++i) {
            FieldNode f = this.cls.searchFieldById(section.readInt());
            f.addAttr(this.readAnnotationSet(section.readInt()));
        }
        for (i = 0; i < annotatedMethodsCount; ++i) {
            MethodNode m3 = this.cls.searchMethodById(section.readInt());
            m3.addAttr(this.readAnnotationSet(section.readInt()));
        }
        for (i = 0; i < annotatedParametersCount; ++i) {
            MethodNode mth = this.cls.searchMethodById(section.readInt());
            Dex.Section ss = this.dex.openSection(section.readInt());
            int size = ss.readInt();
            MethodParameters params = new MethodParameters(size);
            for (int j = 0; j < size; ++j) {
                params.getParamList().add(this.readAnnotationSet(ss.readInt()));
            }
            mth.addAttr(params);
        }
    }

    private AnnotationsList readAnnotationSet(int offset) throws DecodeException {
        if (offset == 0) {
            return AnnotationsList.EMPTY;
        }
        Dex.Section section = this.dex.openSection(offset);
        int size = section.readInt();
        if (size == 0) {
            return AnnotationsList.EMPTY;
        }
        ArrayList<Annotation> list = new ArrayList<Annotation>(size);
        for (int i = 0; i < size; ++i) {
            Dex.Section anSection = this.dex.openSection(section.readInt());
            Annotation a = AnnotationsParser.readAnnotation(this.dex, anSection, true);
            list.add(a);
        }
        return new AnnotationsList(list);
    }

    public static Annotation readAnnotation(DexNode dex, Dex.Section s2, boolean readVisibility) throws DecodeException {
        EncValueParser parser = new EncValueParser(dex, s2);
        Annotation.Visibility visibility = null;
        if (readVisibility) {
            byte v = s2.readByte();
            visibility = VISIBILITIES[v];
        }
        int typeIndex = s2.readUleb128();
        int size = s2.readUleb128();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String name = dex.getString(s2.readUleb128());
            values.put(name, parser.parseValue());
        }
        ArgType type = dex.getType(typeIndex);
        Annotation annotation = new Annotation(visibility, type, values);
        if (!type.isObject()) {
            throw new DecodeException("Incorrect type for annotation: " + annotation);
        }
        return annotation;
    }
}

