/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.clsp.NClass;
import jadx.core.clsp.NMethod;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.GenericInfo;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.DecodeException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.utils.files.ZipSecurity;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClsSet {
    private static final Logger LOG = LoggerFactory.getLogger(ClsSet.class);
    private static final String CLST_EXTENSION = ".jcst";
    private static final String CLST_FILENAME = "core.jcst";
    private static final String CLST_PKG_PATH = ClsSet.class.getPackage().getName().replace('.', '/');
    private static final String JADX_CLS_SET_HEADER = "jadx-cst";
    private static final int VERSION = 2;
    private static final String STRING_CHARSET = "US-ASCII";
    private static final NClass[] EMPTY_NCLASS_ARRAY = new NClass[0];
    private NClass[] classes;

    public void loadFromClstFile() throws IOException, DecodeException {
        try (InputStream input = this.getClass().getResourceAsStream(CLST_FILENAME);){
            if (input == null) {
                throw new JadxRuntimeException("Can't load classpath file: core.jcst");
            }
            this.load(input);
        }
    }

    public void loadFrom(RootNode root) {
        List<ClassNode> list = root.getClasses(true);
        HashMap<String, NClass> names = new HashMap<String, NClass>(list.size());
        int k = 0;
        for (ClassNode cls : list) {
            String clsRawName = cls.getRawName();
            if (cls.getAccessFlags().isPublic()) {
                cls.load();
                NClass nClass = new NClass(clsRawName, k);
                if (names.put(clsRawName, nClass) != null) {
                    throw new JadxRuntimeException("Duplicate class: " + clsRawName);
                }
                ++k;
                nClass.setGenerics(cls.getGenerics());
                nClass.setMethods(this.getMethodsDetails(cls));
                continue;
            }
            names.put(clsRawName, null);
        }
        this.classes = new NClass[k];
        k = 0;
        for (ClassNode cls : list) {
            if (!cls.getAccessFlags().isPublic()) continue;
            NClass nClass = ClsSet.getCls(cls.getRawName(), names);
            if (nClass == null) {
                throw new JadxRuntimeException("Missing class: " + cls);
            }
            nClass.setParents(ClsSet.makeParentsArray(cls, names));
            this.classes[k] = nClass;
            ++k;
        }
    }

    private List<NMethod> getMethodsDetails(ClassNode cls) {
        ArrayList<NMethod> methods = new ArrayList<NMethod>();
        for (MethodNode m3 : cls.getMethods()) {
            AccessInfo accessFlags = m3.getAccessFlags();
            if (!accessFlags.isPublic() && !accessFlags.isProtected()) continue;
            this.processMethodDetails(methods, m3, accessFlags);
        }
        return methods;
    }

    private void processMethodDetails(List<NMethod> methods, MethodNode mth, AccessInfo accessFlags) {
        ArgType[] genericArgs;
        List<ArgType> args = mth.getArgTypes();
        boolean genericArg = false;
        if (args.isEmpty()) {
            genericArgs = null;
        } else {
            int argsCount = args.size();
            genericArgs = new ArgType[argsCount];
            for (int i = 0; i < argsCount; ++i) {
                ArgType argType = args.get(i);
                if (!argType.isGeneric() && !argType.isGenericType()) continue;
                genericArgs[i] = argType;
                genericArg = true;
            }
        }
        ArgType retType = mth.getReturnType();
        if (!retType.isGeneric() && !retType.isGenericType()) {
            retType = null;
        }
        boolean varArgs = accessFlags.isVarArgs();
        if (genericArg || retType != null || varArgs) {
            methods.add(new NMethod(mth.getMethodInfo().getShortId(), genericArgs, retType, varArgs));
        }
    }

    public static NClass[] makeParentsArray(ClassNode cls, Map<String, NClass> names) {
        Object c;
        ArrayList<Object> parents = new ArrayList<Object>(1 + cls.getInterfaces().size());
        ArgType superClass = cls.getSuperClass();
        if (superClass != null && (c = ClsSet.getCls(superClass.getObject(), names)) != null) {
            parents.add(c);
        }
        for (ArgType iface : cls.getInterfaces()) {
            NClass c2 = ClsSet.getCls(iface.getObject(), names);
            if (c2 == null) continue;
            parents.add(c2);
        }
        int size = parents.size();
        if (size == 0) {
            return EMPTY_NCLASS_ARRAY;
        }
        return parents.toArray(new NClass[size]);
    }

    private static NClass getCls(String fullName, Map<String, NClass> names) {
        NClass cls = names.get(fullName);
        if (cls == null) {
            LOG.debug("Class not found: {}", (Object)fullName);
        }
        return cls;
    }

    void save(Path path) throws IOException {
        block40: {
            FileUtils.makeDirsForFile(path);
            String outputName = path.getFileName().toString();
            if (outputName.endsWith(CLST_EXTENSION)) {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                    this.save(outputStream);
                }
            }
            if (outputName.endsWith(".jar")) {
                Path temp = FileUtils.createTempFile(".zip");
                Files.copy(path, temp, StandardCopyOption.REPLACE_EXISTING);
                try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));
                     ZipInputStream in = new ZipInputStream(Files.newInputStream(temp, new OpenOption[0]));){
                    String clst = CLST_PKG_PATH + '/' + CLST_FILENAME;
                    out.putNextEntry(new ZipEntry(clst));
                    this.save(out);
                    ZipEntry entry = in.getNextEntry();
                    while (entry != null) {
                        if (!entry.getName().equals(clst)) {
                            out.putNextEntry(new ZipEntry(entry.getName()));
                            FileUtils.copyStream(in, out);
                        }
                        entry = in.getNextEntry();
                    }
                    break block40;
                }
            }
            throw new JadxRuntimeException("Unknown file format: " + outputName);
        }
    }

    public void save(OutputStream output) throws IOException {
        DataOutputStream out = new DataOutputStream(output);
        out.writeBytes(JADX_CLS_SET_HEADER);
        out.writeByte(2);
        LOG.info("Classes count: {}", (Object)this.classes.length);
        HashMap<String, NClass> names = new HashMap<String, NClass>(this.classes.length);
        out.writeInt(this.classes.length);
        for (NClass cls : this.classes) {
            ClsSet.writeString(out, cls.getName());
            names.put(cls.getName(), cls);
        }
        for (NClass cls : this.classes) {
            NClass[] parents = cls.getParents();
            out.writeByte(parents.length);
            for (NClass parent : parents) {
                out.writeInt(parent.getId());
            }
            ClsSet.writeGenerics(out, cls, names);
            List<NMethod> methods = cls.getMethodsList();
            out.writeByte(methods.size());
            for (NMethod method : methods) {
                ClsSet.writeMethod(out, method, names);
            }
        }
    }

    private static void writeGenerics(DataOutputStream out, NClass cls, Map<String, NClass> names) throws IOException {
        List<GenericInfo> genericsList = cls.getGenerics();
        out.writeByte(genericsList.size());
        for (GenericInfo genericInfo : genericsList) {
            ClsSet.writeArgType(out, genericInfo.getGenericType(), names);
            List<ArgType> extendsList = genericInfo.getExtendsList();
            out.writeByte(extendsList.size());
            for (ArgType type : extendsList) {
                ClsSet.writeArgType(out, type, names);
            }
        }
    }

    private static void writeMethod(DataOutputStream out, NMethod method, Map<String, NClass> names) throws IOException {
        ClsSet.writeLongString(out, method.getShortId());
        ArgType[] argTypes = method.getGenericArgs();
        if (argTypes == null) {
            out.writeByte(0);
        } else {
            int argCount = 0;
            for (ArgType arg : argTypes) {
                if (arg == null) continue;
                ++argCount;
            }
            out.writeByte(argCount);
            for (int i = argTypes.length - 1; i >= 0; --i) {
                ArgType argType = argTypes[i];
                if (argType == null) continue;
                out.writeByte(i);
                ClsSet.writeArgType(out, argType, names);
            }
        }
        if (method.getReturnType() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ClsSet.writeArgType(out, method.getReturnType(), names);
        }
        out.writeBoolean(method.isVarArgs());
    }

    private static void writeArgType(DataOutputStream out, ArgType argType, Map<String, NClass> names) throws IOException {
        if (argType.getWildcardType() != null) {
            out.writeByte(TypeEnum.WILDCARD.ordinal());
            ArgType.WildcardBound bound = argType.getWildcardBound();
            out.writeByte(bound.getNum());
            if (bound != ArgType.WildcardBound.UNBOUND) {
                ClsSet.writeArgType(out, argType.getWildcardType(), names);
            }
        } else if (argType.isGeneric()) {
            out.writeByte(TypeEnum.GENERIC.ordinal());
            out.writeInt(names.get(argType.getObject()).getId());
            ArgType[] types = argType.getGenericTypes();
            if (types == null) {
                out.writeByte(0);
            } else {
                out.writeByte(types.length);
                for (ArgType type : types) {
                    ClsSet.writeArgType(out, type, names);
                }
            }
        } else if (argType.isGenericType()) {
            out.writeByte(TypeEnum.GENERIC_TYPE.ordinal());
            ClsSet.writeString(out, argType.getObject());
        } else if (argType.isObject()) {
            out.writeByte(TypeEnum.OBJECT.ordinal());
            out.writeInt(names.get(argType.getObject()).getId());
        } else if (argType.isArray()) {
            out.writeByte(TypeEnum.ARRAY.ordinal());
            ClsSet.writeArgType(out, argType.getArrayElement(), names);
        } else if (argType.isPrimitive()) {
            out.writeByte(TypeEnum.PRIMITIVE.ordinal());
            out.writeByte(argType.getPrimitiveType().getShortName().charAt(0));
        } else {
            throw new JadxRuntimeException("Cannot save type: " + argType);
        }
    }

    private void load(File input) throws IOException, DecodeException {
        block28: {
            String name = input.getName();
            try (FileInputStream inputStream = new FileInputStream(input);){
                if (name.endsWith(CLST_EXTENSION)) {
                    this.load(inputStream);
                    break block28;
                }
                if (name.endsWith(".jar")) {
                    try (ZipInputStream in = new ZipInputStream(inputStream);){
                        ZipEntry entry = in.getNextEntry();
                        while (entry != null) {
                            if (entry.getName().endsWith(CLST_EXTENSION) && ZipSecurity.isValidZipEntry(entry)) {
                                this.load(in);
                            }
                            entry = in.getNextEntry();
                        }
                        break block28;
                    }
                }
                throw new JadxRuntimeException("Unknown file format: " + name);
            }
        }
    }

    private void load(InputStream input) throws IOException, DecodeException {
        try (DataInputStream in = new DataInputStream(input);){
            int i;
            byte[] header = new byte[JADX_CLS_SET_HEADER.length()];
            int readHeaderLength = in.read(header);
            byte version = in.readByte();
            if (readHeaderLength != JADX_CLS_SET_HEADER.length() || !JADX_CLS_SET_HEADER.equals(new String(header, STRING_CHARSET)) || version != 2) {
                throw new DecodeException("Wrong jadx class set header");
            }
            int count = in.readInt();
            this.classes = new NClass[count];
            for (i = 0; i < count; ++i) {
                String name = ClsSet.readString(in);
                this.classes[i] = new NClass(name, i);
            }
            for (i = 0; i < count; ++i) {
                int pCount = in.readByte();
                NClass[] parents = new NClass[pCount];
                for (int j = 0; j < pCount; ++j) {
                    parents[j] = this.classes[in.readInt()];
                }
                NClass nClass = this.classes[i];
                nClass.setParents(parents);
                nClass.setGenerics(this.readGenerics(in));
                nClass.setMethods(this.readClsMethods(in));
            }
        }
    }

    private List<GenericInfo> readGenerics(DataInputStream in) throws IOException {
        int count = in.readByte();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<GenericInfo> list = new ArrayList<GenericInfo>(count);
        for (int i = 0; i < count; ++i) {
            List<ArgType> extendsList;
            ArgType genericType = this.readArgType(in);
            int extCount = in.readByte();
            if (extCount == 0) {
                extendsList = Collections.emptyList();
            } else {
                extendsList = new ArrayList(extCount);
                for (int j = 0; j < extCount; ++j) {
                    extendsList.add(this.readArgType(in));
                }
            }
            list.add(new GenericInfo(genericType, extendsList));
        }
        return list;
    }

    private List<NMethod> readClsMethods(DataInputStream in) throws IOException {
        int mCount = in.readByte();
        ArrayList<NMethod> methods = new ArrayList<NMethod>(mCount);
        for (int j = 0; j < mCount; ++j) {
            methods.add(this.readMethod(in));
        }
        return methods;
    }

    private NMethod readMethod(DataInputStream in) throws IOException {
        String shortId = ClsSet.readLongString(in);
        int argCount = in.readByte();
        ArgType[] argTypes = null;
        for (int i = 0; i < argCount; ++i) {
            byte index = in.readByte();
            ArgType argType = this.readArgType(in);
            if (argTypes == null) {
                argTypes = new ArgType[index + 1];
            }
            argTypes[index] = argType;
        }
        ArgType retType = in.readBoolean() ? this.readArgType(in) : null;
        boolean varArgs = in.readBoolean();
        return new NMethod(shortId, argTypes, retType, varArgs);
    }

    private ArgType readArgType(DataInputStream in) throws IOException {
        byte ordinal = in.readByte();
        switch (TypeEnum.values()[ordinal]) {
            case WILDCARD: {
                byte bounds = in.readByte();
                return bounds == 0 ? ArgType.wildcard() : ArgType.wildcard(this.readArgType(in), ArgType.WildcardBound.getByNum(bounds));
            }
            case GENERIC: {
                ArgType[] generics;
                String obj = this.classes[in.readInt()].getName();
                int typeLength = in.readByte();
                if (typeLength == 0) {
                    generics = null;
                } else {
                    generics = new ArgType[typeLength];
                    for (int i = 0; i < typeLength; ++i) {
                        generics[i] = this.readArgType(in);
                    }
                }
                return ArgType.generic(obj, generics);
            }
            case GENERIC_TYPE: {
                return ArgType.genericType(ClsSet.readString(in));
            }
            case OBJECT: {
                return ArgType.object(this.classes[in.readInt()].getName());
            }
            case ARRAY: {
                return ArgType.array(this.readArgType(in));
            }
            case PRIMITIVE: {
                char shortName = (char)in.readByte();
                return ArgType.parse(shortName);
            }
        }
        throw new JadxRuntimeException("Unsupported Arg Type: " + ordinal);
    }

    private static void writeString(DataOutputStream out, String name) throws IOException {
        byte[] bytes = name.getBytes(STRING_CHARSET);
        out.writeByte(bytes.length);
        out.write(bytes);
    }

    private static void writeLongString(DataOutputStream out, String name) throws IOException {
        byte[] bytes = name.getBytes(STRING_CHARSET);
        out.writeShort(bytes.length);
        out.write(bytes);
    }

    private static String readString(DataInputStream in) throws IOException {
        byte len = in.readByte();
        return ClsSet.readString(in, len);
    }

    private static String readLongString(DataInputStream in) throws IOException {
        short len = in.readShort();
        return ClsSet.readString(in, len);
    }

    private static String readString(DataInputStream in, int len) throws IOException {
        int res;
        byte[] bytes = new byte[len];
        for (int count = in.read(bytes); count != len; count += res) {
            res = in.read(bytes, count, len - count);
            if (res != -1) continue;
            throw new IOException("String read error");
        }
        return new String(bytes, STRING_CHARSET);
    }

    public int getClassesCount() {
        return this.classes.length;
    }

    public void addToMap(Map<String, NClass> nameMap) {
        for (NClass cls : this.classes) {
            nameMap.put(cls.getName(), cls);
        }
    }

    private static enum TypeEnum {
        WILDCARD,
        GENERIC,
        GENERIC_TYPE,
        OBJECT,
        ARRAY,
        PRIMITIVE;

    }
}

