/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import jadx.api.JadxDecompiler;
import jadx.cli.JadxCLIArgs;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JCommanderWrapper<T> {
    private final JCommander jc;

    public JCommanderWrapper(T obj) {
        this.jc = JCommander.newBuilder().addObject(obj).build();
    }

    public boolean parse(String[] args) {
        try {
            this.jc.parse(args);
            return true;
        }
        catch (ParameterException e) {
            System.err.println("Arguments parse error: " + e.getMessage());
            this.printUsage();
            return false;
        }
    }

    public void overrideProvided(T obj) {
        List<ParameterDescription> fieldsParams = this.jc.getParameters();
        ArrayList<ParameterDescription> parameters = new ArrayList<ParameterDescription>(1 + fieldsParams.size());
        parameters.add(this.jc.getMainParameterValue());
        parameters.addAll(fieldsParams);
        for (ParameterDescription parameter : parameters) {
            if (!parameter.isAssigned()) continue;
            Parameterized parameterized = parameter.getParameterized();
            Object val = parameterized.get(parameter.getObject());
            parameterized.set(obj, val);
        }
    }

    public void printUsage() {
        PrintStream out = System.out;
        out.println();
        out.println("jadx - dex to java decompiler, version: " + JadxDecompiler.getVersion());
        out.println();
        out.println("usage: jadx [options] " + this.jc.getMainParameterDescription());
        out.println("options:");
        List<ParameterDescription> params = this.jc.getParameters();
        LinkedHashMap<String, ParameterDescription> paramsMap = new LinkedHashMap<String, ParameterDescription>(params.size());
        int maxNamesLen = 0;
        for (ParameterDescription p : params) {
            paramsMap.put(p.getParameterized().getName(), p);
            int len = p.getNames().length();
            if (len <= maxNamesLen) continue;
            maxNamesLen = len;
        }
        JadxCLIArgs args = (JadxCLIArgs)this.jc.getObjects().get(0);
        for (Field f : this.getFields(args.getClass())) {
            String name = f.getName();
            ParameterDescription p = (ParameterDescription)paramsMap.get(name);
            if (p == null) continue;
            StringBuilder opt = new StringBuilder();
            opt.append("  ").append(p.getNames());
            JCommanderWrapper.addSpaces(opt, maxNamesLen - opt.length() + 3);
            opt.append("- ").append(p.getDescription());
            String defaultValue = this.getDefaultValue(args, f, opt);
            if (defaultValue != null) {
                opt.append(", default: ").append(defaultValue);
            }
            out.println(opt);
        }
        out.println("Example:");
        out.println("  jadx -d out classes.dex");
    }

    private List<Field> getFields(Class<?> clazz) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    @Nullable
    private String getDefaultValue(JadxCLIArgs args, Field f, StringBuilder opt) {
        try {
            Enum val;
            Class<?> fieldType = f.getType();
            if (fieldType == Integer.TYPE) {
                return Integer.toString(f.getInt(args));
            }
            if (fieldType == String.class) {
                return (String)f.get(args);
            }
            if (Enum.class.isAssignableFrom(fieldType) && (val = (Enum)f.get(args)) != null) {
                return val.name();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void addSpaces(StringBuilder str, int count) {
        for (int i = 0; i < count; ++i) {
            str.append(' ');
        }
    }
}

