/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import java.util.Collections;
import java.util.List;

public final class JavaMethod
implements JavaNode {
    private final MethodNode mth;
    private final JavaClass parent;

    JavaMethod(JavaClass cls, MethodNode m3) {
        this.parent = cls;
        this.mth = m3;
    }

    @Override
    public String getName() {
        return this.mth.getAlias();
    }

    @Override
    public String getFullName() {
        return this.mth.getMethodInfo().getFullName();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent.getTopParentClass();
    }

    public AccessInfo getAccessFlags() {
        return this.mth.getAccessFlags();
    }

    public List<ArgType> getArguments() {
        List<ArgType> infoArgTypes = this.mth.getMethodInfo().getArgumentsTypes();
        if (infoArgTypes.isEmpty()) {
            return Collections.emptyList();
        }
        List<ArgType> arguments = this.mth.getArgTypes();
        if (arguments == null) {
            arguments = infoArgTypes;
        }
        return Utils.collectionMap(arguments, type -> ArgType.tryToResolveClassAlias(this.mth.dex(), type));
    }

    public ArgType getReturnType() {
        ArgType retType = this.mth.getReturnType();
        if (retType == null) {
            retType = this.mth.getMethodInfo().getReturnType();
        }
        return ArgType.tryToResolveClassAlias(this.mth.dex(), retType);
    }

    public boolean isConstructor() {
        return this.mth.getMethodInfo().isConstructor();
    }

    public boolean isClassInit() {
        return this.mth.getMethodInfo().isClassInit();
    }

    @Override
    public int getDecompiledLine() {
        return this.mth.getDecompiledLine();
    }

    MethodNode getMethodNode() {
        return this.mth;
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaMethod && this.mth.equals(((JavaMethod)o).mth);
    }

    public String toString() {
        return this.mth.toString();
    }
}

