/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.CodePosition;
import jadx.api.ICodeInfo;
import jadx.api.JadxDecompiler;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class JavaClass
implements JavaNode {
    private final JadxDecompiler decompiler;
    private final ClassNode cls;
    private final JavaClass parent;
    private List<JavaClass> innerClasses = Collections.emptyList();
    private List<JavaField> fields = Collections.emptyList();
    private List<JavaMethod> methods = Collections.emptyList();
    private boolean listsLoaded;

    JavaClass(ClassNode classNode, JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.cls = classNode;
        this.parent = null;
    }

    JavaClass(ClassNode classNode, JavaClass parent) {
        this.decompiler = null;
        this.cls = classNode;
        this.parent = parent;
    }

    public String getCode() {
        ICodeInfo code = this.getCodeInfo();
        if (code == null) {
            return "";
        }
        return code.getCodeStr();
    }

    public ICodeInfo getCodeInfo() {
        return this.cls.decompile();
    }

    public void decompile() {
        this.cls.decompile();
    }

    public synchronized String getSmali() {
        return this.cls.getSmali();
    }

    public synchronized void unload() {
        this.cls.unload();
        this.listsLoaded = false;
    }

    public ClassNode getClassNode() {
        return this.cls;
    }

    private void loadLists() {
        int methodsCount;
        int fieldsCount;
        if (this.listsLoaded) {
            return;
        }
        this.listsLoaded = true;
        this.decompile();
        int inClsCount = this.cls.getInnerClasses().size();
        if (inClsCount != 0) {
            ArrayList<JavaClass> list = new ArrayList<JavaClass>(inClsCount);
            for (ClassNode classNode : this.cls.getInnerClasses()) {
                if (classNode.contains(AFlag.DONT_GENERATE)) continue;
                JavaClass javaClass = new JavaClass(classNode, this);
                javaClass.loadLists();
                list.add(javaClass);
            }
            this.innerClasses = Collections.unmodifiableList(list);
        }
        if ((fieldsCount = this.cls.getFields().size()) != 0) {
            ArrayList<JavaField> flds = new ArrayList<JavaField>(fieldsCount);
            for (FieldNode f : this.cls.getFields()) {
                if (f.contains(AFlag.DONT_GENERATE)) continue;
                JavaField javaField = new JavaField(f, this);
                flds.add(javaField);
            }
            this.fields = Collections.unmodifiableList(flds);
        }
        if ((methodsCount = this.cls.getMethods().size()) != 0) {
            ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>(methodsCount);
            for (MethodNode m3 : this.cls.getMethods()) {
                if (m3.contains(AFlag.DONT_GENERATE)) continue;
                JavaMethod javaMethod = new JavaMethod(this, m3);
                arrayList.add(javaMethod);
            }
            arrayList.sort(Comparator.comparing(JavaMethod::getName));
            this.methods = Collections.unmodifiableList(arrayList);
        }
    }

    private JadxDecompiler getRootDecompiler() {
        if (this.parent != null) {
            return this.parent.getRootDecompiler();
        }
        return this.decompiler;
    }

    private Map<CodePosition, Object> getCodeAnnotations() {
        ICodeInfo code = this.getCodeInfo();
        if (code == null) {
            return Collections.emptyMap();
        }
        return code.getAnnotations();
    }

    public Map<CodePosition, JavaNode> getUsageMap() {
        Map<CodePosition, Object> map = this.getCodeAnnotations();
        if (map.isEmpty() || this.decompiler == null) {
            return Collections.emptyMap();
        }
        HashMap<CodePosition, JavaNode> resultMap = new HashMap<CodePosition, JavaNode>(map.size());
        for (Map.Entry<CodePosition, Object> entry : map.entrySet()) {
            CodePosition codePosition = entry.getKey();
            Object obj = entry.getValue();
            JavaNode node = this.getRootDecompiler().convertNode(obj);
            if (node == null) continue;
            resultMap.put(codePosition, node);
        }
        return resultMap;
    }

    @Deprecated
    @Nullable
    public JavaNode getJavaNodeAtPosition(int line, int offset) {
        return this.getRootDecompiler().getJavaNodeAtPosition(this.getCodeInfo(), line, offset);
    }

    @Deprecated
    @Nullable
    public CodePosition getDefinitionPosition() {
        return this.getRootDecompiler().getDefinitionPosition(this);
    }

    public Integer getSourceLine(int decompiledLine) {
        return this.getCodeInfo().getLineMapping().get(decompiledLine);
    }

    @Override
    public String getName() {
        return this.cls.getShortName();
    }

    @Override
    public String getFullName() {
        return this.cls.getFullName();
    }

    public String getPackage() {
        return this.cls.getPackage();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent == null ? this : this.parent.getTopParentClass();
    }

    public AccessInfo getAccessInfo() {
        return this.cls.getAccessFlags();
    }

    public List<JavaClass> getInnerClasses() {
        this.loadLists();
        return this.innerClasses;
    }

    public List<JavaField> getFields() {
        this.loadLists();
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        this.loadLists();
        return this.methods;
    }

    @Override
    public int getDecompiledLine() {
        return this.cls.getDecompiledLine();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaClass && this.cls.equals(((JavaClass)o).cls);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public String toString() {
        return this.getFullName();
    }
}

