/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

final class WindowEventObservable
extends Observable<WindowEvent> {
    final Window widget;
    final int flags;

    WindowEventObservable(Window widget, int flags) {
        this.widget = widget;
        this.flags = flags;
    }

    @Override
    protected void subscribeActual(Observer<? super WindowEvent> observer) {
        Window w = this.widget;
        int f = this.flags;
        WindowEventConsumer aec = new WindowEventConsumer(observer, w, f);
        observer.onSubscribe(aec);
        if ((f & 1) != 0) {
            w.addWindowListener(aec);
        }
        if ((f & 2) != 0) {
            w.addWindowFocusListener(aec);
        }
        if ((f & 4) != 0) {
            w.addWindowStateListener(aec);
        }
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class WindowEventConsumer
    extends AbstractEventConsumer<WindowEvent, Window>
    implements WindowListener,
    WindowFocusListener,
    WindowStateListener {
        private static final long serialVersionUID = -3605206827474016488L;
        final int flags;

        WindowEventConsumer(Observer<? super WindowEvent> actual, Window widget, int flags) {
            super(actual, widget);
            this.flags = flags;
        }

        @Override
        protected void onDispose(Window w) {
            int f = this.flags;
            if ((f & 1) != 0) {
                w.removeWindowListener(this);
            }
            if ((f & 2) != 0) {
                w.removeWindowFocusListener(this);
            }
            if ((f & 4) != 0) {
                w.removeWindowStateListener(this);
            }
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.actual.onNext(e);
        }
    }
}

