/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import hu.akarnokd.rxjava2.swing.VetoablePropertyChangeEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;

final class VetoableChangeEventObservable
extends Observable<VetoablePropertyChangeEvent> {
    final JComponent widget;

    VetoableChangeEventObservable(JComponent widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super VetoablePropertyChangeEvent> observer) {
        JComponent w = this.widget;
        PropertyChangeEventConsumer aec = new PropertyChangeEventConsumer(observer, w);
        observer.onSubscribe(aec);
        w.addVetoableChangeListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class PropertyChangeEventConsumer
    extends AbstractEventConsumer<VetoablePropertyChangeEvent, JComponent>
    implements VetoableChangeListener {
        private static final long serialVersionUID = -3605206827474016488L;

        PropertyChangeEventConsumer(Observer<? super VetoablePropertyChangeEvent> actual, JComponent widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(JComponent w) {
            w.removeVetoableChangeListener(this);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            VetoablePropertyChangeEvent e = new VetoablePropertyChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            e.setPropagationId(evt.getPropagationId());
            this.actual.onNext(e);
            if (e.isVetoed()) {
                throw new PropertyVetoException("Vetoed", evt);
            }
        }
    }
}

