/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

final class TreeExpansionEventObservable
extends Observable<TreeExpansionEvent> {
    final JTree widget;

    TreeExpansionEventObservable(JTree widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super TreeExpansionEvent> observer) {
        JTree w = this.widget;
        TreeExpansionEventConsumer aec = new TreeExpansionEventConsumer(observer, w);
        observer.onSubscribe(aec);
        w.addTreeExpansionListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class TreeExpansionEventConsumer
    extends AbstractEventConsumer<TreeExpansionEvent, JTree>
    implements TreeExpansionListener {
        private static final long serialVersionUID = -3605206827474016488L;

        TreeExpansionEventConsumer(Observer<? super TreeExpansionEvent> actual, JTree widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(JTree w) {
            w.removeTreeExpansionListener(this);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.actual.onNext(event);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.actual.onNext(event);
        }
    }
}

