/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.awt.EventQueue;

final class SwingObserveOn<T>
extends Observable<T>
implements ObservableTransformer<T, T> {
    final Observable<T> source;

    SwingObserveOn(Observable<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new ObserveOnObserver<T>(observer));
    }

    @Override
    public ObservableSource<T> apply(Observable<T> upstream) {
        return new SwingObserveOn<T>(upstream);
    }

    static final class ObserveOnObserver<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        final Observer<? super T> actual;
        Disposable upstream;
        volatile boolean disposed;

        ObserveOnObserver(Observer<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            EventQueue.invokeLater(new OnNextEvent<T>(this.actual, t, this));
        }

        @Override
        public void onError(Throwable e) {
            EventQueue.invokeLater(new OnErrorEvent<T>(this.actual, e, this));
        }

        @Override
        public void onComplete() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            if (!this.disposed) {
                this.actual.onComplete();
            }
        }

        static final class OnErrorEvent<T>
        implements Runnable {
            final Observer<? super T> actual;
            final Throwable event;
            final Disposable d;

            OnErrorEvent(Observer<? super T> actual, Throwable event, Disposable d) {
                this.actual = actual;
                this.event = event;
                this.d = d;
            }

            @Override
            public void run() {
                if (!this.d.isDisposed()) {
                    this.actual.onError(this.event);
                }
            }
        }

        static final class OnNextEvent<T>
        implements Runnable {
            final Observer<? super T> actual;
            final T event;
            final Disposable d;

            OnNextEvent(Observer<? super T> actual, T event, Disposable d) {
                this.actual = actual;
                this.event = event;
                this.d = d;
            }

            @Override
            public void run() {
                if (!this.d.isDisposed()) {
                    this.actual.onNext(this.event);
                }
            }
        }
    }
}

