/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.internal.util.ExceptionHelper;

public final class RxSwingPlugins {
    private static volatile Function<Runnable, Runnable> onSchedule;
    private static volatile Function<Scheduler, Scheduler> onEdtScheduler;
    private static volatile Function<Observable, Observable> onAssembly;

    private RxSwingPlugins() {
        throw new IllegalStateException("No instances!");
    }

    public static Runnable onSchedule(Runnable run) {
        Function<Runnable, Runnable> f = onSchedule;
        if (f == null) {
            return run;
        }
        try {
            return f.apply(run);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
    }

    public static Scheduler onEdtScheduler(Scheduler original) {
        Function<Scheduler, Scheduler> f = onEdtScheduler;
        if (f == null) {
            return original;
        }
        try {
            return f.apply(original);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
    }

    public static <T> Observable<T> onAssembly(Observable<T> original) {
        Function<Observable, Observable> f = onAssembly;
        if (f == null) {
            return original;
        }
        try {
            return f.apply(original);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
    }

    public static Function<Runnable, Runnable> getOnSchedule() {
        return onSchedule;
    }

    public static void setOnSchedule(Function<Runnable, Runnable> handler) {
        onSchedule = handler;
    }

    public static Function<Scheduler, Scheduler> getOnEdtScheduler() {
        return onEdtScheduler;
    }

    public static void setOnEdtScheduler(Function<Scheduler, Scheduler> handler) {
        onEdtScheduler = handler;
    }

    public static Function<Observable, Observable> getOnAssembly() {
        return onAssembly;
    }

    public static void setOnAssembly(Function<Observable, Observable> handler) {
        onAssembly = handler;
    }

    public static void reset() {
        onSchedule = null;
        onEdtScheduler = null;
        onAssembly = null;
    }
}

