/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

final class PropertyChangeEventObservable
extends Observable<PropertyChangeEvent> {
    final Component widget;
    final String propertyName;

    PropertyChangeEventObservable(Component widget, String propertyName) {
        this.widget = widget;
        this.propertyName = propertyName;
    }

    @Override
    protected void subscribeActual(Observer<? super PropertyChangeEvent> observer) {
        Component w = this.widget;
        String pn = this.propertyName;
        PropertyChangeEventConsumer aec = new PropertyChangeEventConsumer(observer, w, pn);
        observer.onSubscribe(aec);
        if (pn == null) {
            w.addPropertyChangeListener(aec);
        } else {
            w.addPropertyChangeListener(pn, aec);
        }
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class PropertyChangeEventConsumer
    extends AbstractEventConsumer<PropertyChangeEvent, Component>
    implements PropertyChangeListener {
        private static final long serialVersionUID = -3605206827474016488L;
        final String propertyName;

        PropertyChangeEventConsumer(Observer<? super PropertyChangeEvent> actual, Component widget, String propertyName) {
            super(actual, widget);
            this.propertyName = propertyName;
        }

        @Override
        protected void onDispose(Component w) {
            String pn = this.propertyName;
            if (pn == null) {
                w.removePropertyChangeListener(this);
            } else {
                w.removePropertyChangeListener(pn, this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.actual.onNext(evt);
        }
    }
}

