/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

final class MouseEventObservable
extends Observable<MouseEvent> {
    final Component widget;
    final int flags;

    MouseEventObservable(Component widget, int flags) {
        this.widget = widget;
        this.flags = flags;
    }

    @Override
    protected void subscribeActual(Observer<? super MouseEvent> observer) {
        Component w = this.widget;
        int f = this.flags;
        MouseEventConsumer aec = new MouseEventConsumer(observer, w, f);
        observer.onSubscribe(aec);
        if ((f & 1) != 0) {
            w.addMouseListener(aec);
        }
        if ((f & 2) != 0) {
            w.addMouseMotionListener(aec);
        }
        if ((f & 4) != 0) {
            w.addMouseWheelListener(aec);
        }
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class MouseEventConsumer
    extends AbstractEventConsumer<MouseEvent, Component>
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = -3605206827474016488L;
        final int flags;

        MouseEventConsumer(Observer<? super MouseEvent> actual, Component widget, int flags) {
            super(actual, widget);
            this.flags = flags;
        }

        @Override
        protected void onDispose(Component w) {
            int f = this.flags;
            if ((f & 1) != 0) {
                w.removeMouseListener(this);
            }
            if ((f & 2) != 0) {
                w.removeMouseMotionListener(this);
            }
            if ((f & 4) != 0) {
                w.removeMouseWheelListener(this);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.actual.onNext(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.actual.onNext(e);
        }
    }
}

