/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import java.awt.Component;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;

final class InputMethodEventObservable
extends Observable<InputMethodEvent> {
    final Component widget;

    InputMethodEventObservable(Component widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super InputMethodEvent> observer) {
        Component w = this.widget;
        InputMethodEventConsumer aec = new InputMethodEventConsumer(observer, w);
        observer.onSubscribe(aec);
        w.addInputMethodListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class InputMethodEventConsumer
    extends AbstractEventConsumer<InputMethodEvent, Component>
    implements InputMethodListener {
        private static final long serialVersionUID = -3605206827474016488L;

        InputMethodEventConsumer(Observer<? super InputMethodEvent> actual, Component widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(Component w) {
            w.removeInputMethodListener(this);
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent event) {
            this.actual.onNext(event);
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
            this.actual.onNext(event);
        }
    }
}

