/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

final class HyperlinkEventObservable
extends Observable<HyperlinkEvent> {
    final JEditorPane widget;

    HyperlinkEventObservable(JEditorPane widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super HyperlinkEvent> observer) {
        JEditorPane w = this.widget;
        HyperlinkEventConsumer aec = new HyperlinkEventConsumer(observer, w);
        observer.onSubscribe(aec);
        w.addHyperlinkListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class HyperlinkEventConsumer
    extends AbstractEventConsumer<HyperlinkEvent, JEditorPane>
    implements HyperlinkListener {
        private static final long serialVersionUID = -3605206827474016488L;

        HyperlinkEventConsumer(Observer<? super HyperlinkEvent> actual, JEditorPane widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(JEditorPane w) {
            w.removeHyperlinkListener(this);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            this.actual.onNext(e);
        }
    }
}

