/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.AbstractEventConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

final class AncestorEventObservable
extends Observable<AncestorEvent> {
    final JComponent widget;

    AncestorEventObservable(JComponent widget) {
        this.widget = widget;
    }

    @Override
    protected void subscribeActual(Observer<? super AncestorEvent> observer) {
        JComponent w = this.widget;
        AncestorEventConsumer aec = new AncestorEventConsumer(observer, w);
        observer.onSubscribe(aec);
        w.addAncestorListener(aec);
        if (aec.get() == null) {
            aec.onDispose(w);
        }
    }

    static final class AncestorEventConsumer
    extends AbstractEventConsumer<AncestorEvent, JComponent>
    implements AncestorListener {
        private static final long serialVersionUID = -3605206827474016488L;

        AncestorEventConsumer(Observer<? super AncestorEvent> actual, JComponent widget) {
            super(actual, widget);
        }

        @Override
        protected void onDispose(JComponent w) {
            w.removeAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.actual.onNext(event);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.actual.onNext(event);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.actual.onNext(event);
        }
    }
}

